<?php
session_start();
include '../includes/config.php';
header('Content-Type: application/json');

$raw = file_get_contents('php://input');
$data = json_decode($raw, true);

$order_id = $data['order_id'] ?? '';
$payment_id = $data['payment_id'] ?? '';
$signature = $data['signature'] ?? '';
$phone = $data['phone'] ?? '';

if (!$order_id || !$payment_id || !$signature) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'missing']);
    exit;
}

$token = $flexsecure_upikey ?? '';
if (empty($token)) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'token']);
    exit;
}

$verify_body = json_encode([
    'order_id' => $order_id,
    'payment_id' => $payment_id,
    'signature' => $signature
]);

$ch = curl_init('https://merchants.crazzype.com/api/orders/verify-payment');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $verify_body);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'Authorization: Bearer ' . $token
]);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
$resp = curl_exec($ch);
curl_close($ch);

$v = @json_decode($resp, true);
if (!is_array($v) || empty($v['verified'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'not_verified']);
    exit;
}

$wq = mysqli_query($ahk_conn, "SELECT * FROM wallet WHERE txn_id='" . mysqli_real_escape_string($ahk_conn, $order_id) . "' LIMIT 1");
if (!$wq || mysqli_num_rows($wq) != 1) {
    http_response_code(404);
    echo json_encode(['status' => 'error', 'message' => 'txn_missing']);
    exit;
}
$txn = mysqli_fetch_assoc($wq);
if ($txn['status'] === 'success') {
    echo json_encode(['status' => 'success', 'message' => 'already']);
    exit;
}
$amt = floatval($txn['amount']);
$mob = $txn['phone'];

mysqli_begin_transaction($ahk_conn);
$u1 = mysqli_query($ahk_conn, "UPDATE wallet SET status='success', BANKTXNID='" . mysqli_real_escape_string($ahk_conn, $payment_id) . "', RESPMSG='Payment verified', PAYMENTMODE='CrazzyPe' WHERE txn_id='" . mysqli_real_escape_string($ahk_conn, $order_id) . "'");
$u2 = mysqli_query($ahk_conn, "UPDATE users SET balance = balance + {$amt} WHERE phone='" . mysqli_real_escape_string($ahk_conn, $mob) . "'");
if ($u1 && $u2) {
    mysqli_commit($ahk_conn);
    echo json_encode(['status' => 'success']);
} else {
    mysqli_rollback($ahk_conn);
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'db']);
}
?>
